ScriptName RF:ShipTrackerScript Extends ReferenceAlias

RF:FuelHandlerQuest Property FuelManager Auto Mandatory Const
RF:TravelHandlerQuest Property TravelManager Mandatory Const Auto
ActorValue Property SpaceshipGravJumpFuel auto const mandatory

bool ModRunning = false

Event OnShipFarTravel(Location aDepartureLocation, Location aArrivalLocation, int aState)
    IF ModRunning
        FuelManager.HandleFarTravel(aDepartureLocation, aArrivalLocation, aState)
    EndIf
EndEvent

Event OnShipDock(bool abComplete, SpaceshipReference akDocking, SpaceshipReference akParent)
    IF ModRunning
        FuelManager.HandleDocking(abComplete, akDocking, akParent)
    EndIf
EndEvent

Event OnShipUndock(bool abComplete, SpaceshipReference akUndocking, SpaceshipReference akParent)
    IF ModRunning
        FuelManager.HandleUndocking(abComplete, akUndocking, akParent)
    EndIf
EndEvent

Event OnShipGravJump(Location aDestination, int aState)
    IF ModRunning
        FuelManager.HandleGravJump(aDestination, aState)
    EndIf
EndEvent

Event OnShipRefueled(int aFuelAdded)
    IF ModRunning
        FuelManager.HandleRefuel(aFuelAdded)
    EndIf
EndEvent

Event OnLocationChange(Location akOldLoc, Location akNewLoc)
    ModRunning = FuelManager.ModRunning()
    bool OKGO = True
    If ModRunning
        If !FuelManager.GetWasJumpIntrasystem(akOldLoc, akNewLoc) ; Don't check this explicitly as it includes our pre-fueled failure modes
            OKGO = TravelManager.HandleTravelRestriction(akOldLoc, akNewLoc)
        EndIf
        FuelManager.HandleLocChange(akOldLoc, akNewLoc, OKGO)
    EndIf
EndEvent

Event OnShipTakeOff(bool abComplete)
    ModRunning = FuelManager.ModRunning()
    IF ModRunning
        FuelManager.HandleShipTakeOff(abComplete)
    EndIF
EndEvent